

function get_recyclable_vert_name(vertNum)
	return "recyclable_" .. vertNum
end

function get_recyclable_var(vertNum)
	return game:GetCurrentScene() .. "_recyclable_" .. vertNum;
end

-- spawn recyclable items if there are named recyclable verts in the scene (i.e. "recyclable_1", "recyclable_10")
function spawn_recyclables()
	local currentScene = game:GetCurrentScene();
	local spawned_recyclables = game:Get(currentScene .. "_spawned_recyclables");
	local recyclables_to_spawn = recyclable_info.scene_total[currentScene];
	
	if recyclables_to_spawn == nil then
		return;
	end
	
	if spawned_recyclables == 1 then
		-- spawn any existing recyclables
		for i = 1, recyclable_info.max_verts do
			if game:Get(get_recyclable_var(i)) > 0 then
				local recyclableVertName = get_recyclable_vert_name(i);
				local recyclableVar = get_recyclable_var(i);
				local recyclableType = game:Get(recyclableVar);
				local recyclableSpec = get_recyclable_spec(recyclableVertName, recyclableVar, recyclableType);
				scene:Spawn(recyclableSpec);
			end
		end
	else
		local recyclables_spawned = 0;
		local vertCount = 0;
		
		-- spawn loop
		while true do
			-- if we're spawned everything we wanted to spawn or we've found no suitable verts to spawn recyclables at then
			-- we're done
			if recyclables_spawned == recyclables_to_spawn 
				or vertCount == recyclable_info.max_verts then
				break;
			end		
		
			local vertSpawnNum = math.random(1, recyclable_info.max_verts);
			
			-- search through all possible verts for the vert to spawn the recyclable at
			while vertCount < recyclable_info.max_verts do
				local vertName = get_recyclable_vert_name(vertSpawnNum);
				local recyclableVar = get_recyclable_var(vertSpawnNum);
				
				-- if the vert we are looking for exists and there isn't already a recyclable spawned there
				-- spawn the recyclable and break
				if scene.mesh:VertExists(vertName) and game:Get(recyclableVar) < 1 then
					local recyclableType = fmod(vertSpawnNum, recyclable_info.max_types);
					if recyclableType == 0 then
						recyclableType = recyclable_info.max_types;
					end
					scene:Spawn(get_recyclable_spec(vertName, recyclableVar, recyclableType));
					recyclables_spawned = recyclables_spawned + 1;
					vertCount = 0;
					break;
				else -- else increment the vert count and keep looking
					vertCount = vertCount + 1;
					vertSpawnNum = vertSpawnNum + 1;
					
					-- loop back if we're over our potential vert number
					if vertSpawnNum > recyclable_info.max_verts then
						vertSpawnNum = 1;
					end
				end
			end
		end
		
		if recyclables_spawned ~= recyclables_to_spawn then
			GlobalLuaError("ERROR: Not enough verts in scene to spawn all recyclables. Only " .. recyclables_spawned .. " verts found");
		end
		
		game:Set(currentScene .. "_spawned_recyclables", 1);
		
		--debug_out("recyclables spawned = " .. recyclables_spawned);
	end
end

tempRecyclable = 0; -- hacky variable for passing to pickup function

function pickup_recyclable(flo)
	flo:SetMode(MODE.CUTSCENE);
	
	sfx:PlaySFX("audio/sfx/bottle_pickup.ogg");
	
	if game:Get("first_time_picked_up_recyclable") < 1 then
		run_super_conversation(flo, "conv_first_time_pickup_recyclable");
		game:Set("first_time_picked_up_recyclable", 1);
	end
	
	local position = tempRecyclable:GetScreenPosition();
	
	-- reset our recyclable game var and get rid of it
	game:Set(tempRecyclable.recyclableVar, 0);
	tempRecyclable:Expire();
	tempRecyclable = 0;
	
	local key = "recyclable";
	
	-- add a recyclable to inventory
	if not BAG_INV:CheckInventory(key) then
		addInventory(inv_desc_recyclable);
	else
		game:SetString("inventory_fly_back_item", key);
		game:Set("inventory_fly_back_loc_X", position.x);
		game:Set("inventory_fly_back_loc_Y", position.y);
		
		-- scroll so the item's SLOT is visible
		BAG_INV:PositionInventoryForVisibility(key);
		
		-- go straight there (don't wait)
		BAG_INV:JumpInventoryToTarget(key);
		
		-- do the work
		scene:Spawn(inventory_flyback_spec);
		coroutine.yield(RESUME.ON_SIGNAL);
		
		--delay(30); -- make it snappy!
		scene.INVENTORY_FLYBACK:Expire();
		delay(2);
	end
	
	-- increment our recyclable count and update it on the inventory display
	local recyclableCount = game:Get("recyclable_count");
	
	if recyclableCount == nil then
		recyclableCount = 1;
	else
		recyclableCount = recyclableCount + 1;
	end
	
	BAG_INV:SetInventoryOvertextFlags("recyclable", kHAlignRight + kVAlignTop);
	BAG_INV:SetInventoryOvertext("recyclable", recyclableCount);
	game:Set("recyclable_count", recyclableCount);
	
	MET_Count("BottlesCollected");
	
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function get_recyclable_spec(vertName, recyclableVar, recyclableType)
	return
	{
		name = vertName;
		halo = "quest/recyclables/" .. recyclableType;
		gfx = { image = "quest/recyclables/" .. recyclableType };
		
		command = function(actor)
			actor:SetDepthMode(DEPTH.DEPTH_BY_Y);
			actor:JumpToNamedPoint(vertName);
			actor:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
			actor:ModifySaySpec {
				color = { a = 1, r = 1, g = 1, b = 1 },
				x = 0, y = 0,
				w = 120, h = 100, 
				outline_size = 2, 
				bubble = false,
				anchor = ANCHOR.CENTER};
				
			--actor:SayRaw(vertName .. " " .. recyclableVar);
			
			actor.vertName = vertName;
			actor.recyclableVar = recyclableVar;
			
			game:Set(recyclableVar, recyclableType);
			
			actor.on_click = function(flo, recyclable)
				tempRecyclable = recyclable; -- hacky
				flo:StartProc(pickup_recyclable);
				return RESPONSE.IGNORE;
			end;
		end;
	}
end
